#Ce programme corrige à la fois l'exercice A et B1.

import sys
from typing import List

def read_text_file(path: str) -> List[str]:
	"""
	Lit un fichier texte et renvoi le contenu des lignes dans un tableau.

	@param path le chemin vers le fichier à lire
	@return un tableau contenant les lignes du fichiers

	Postconditions : les exceptions sont gérées et le cas échéant, le tableau retourné est vide
	"""
	lines = []
	try:
		with open(path, "rt") as f:
			while line := f.readline():
				lines.append(line[:-1]) #-1 enlève le \n à la fin de la ligne
	except FileNotFoundError:
		print("erreur : le fichier n'existe pas", file=sys.stderr)
	except PermissionError:
		print("erreur : accès refusé", file=sys.stderr)
	except OSError as e:
		print("erreur : " + str(e), file=sys.stderr)
	return lines

if __name__ == "__main__":
	if len(sys.argv) != 2:
		print("erreur : argument manquant", file=sys.stderr)
		print("usage : " + sys.argv[0] + " chemin/vers/fichier_texte", file=sys.stderr)
		sys.exit(1)

	lines = read_text_file(sys.argv[1])
	for i in range(len(lines)):
		print(str(i).rjust(2) + " : " + lines[i])
